-- Fichero SFSQLdes.sql
-------------------------------------------------
-- DESINSTALAR SERVIDOR FSQL:                  --
-- Borra las tablas y paquetes PL/SQL propios  --
-- del servidor FSQL                           --
-------------------------------------------------

-- Para que salgan los mensajes (de put_line) al instalar desde FSQL*Plus:
set serveroutput on
-- Para que salgan (o no) las ordenes a ejecutar: set echo on
set echo off
-- Para que no salgan los mensajes cuando todo va bien (los errores si salen):
set feedback off

exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> ****************************************** <<<<');
exec dbms_output.put_line('>>>> **** DESINSTALACIN del SERVIDOR FSQL **** <<<<');
exec dbms_output.put_line('>>>> ****************************************** <<<< by J. Galindo G.');
exec dbms_output.put_line('>>>>');

-- VISTAS accesibles por el USUARIO particular
DROP VIEW FSQL_ERRORS;
DROP VIEW FSQL_QUERY;
DROP VIEW FSQL_OPTIONS;
DROP VIEW FSQL_INFO;

-- TABLAS para el ANALISIS LXICO y otros
DROP TABLE FSQL_ALL_ERRORS;
DROP TABLE FSQL_ALL_QUERIES;
DROP TABLE FSQL_ALL_INFO;
DROP TABLE FSQL_STATS;
DROP TABLE RESERVADAS;
DROP TABLE T_TRANSI;

-- TABLAS para el ANALISIS SINTCTICO
DROP TABLE PRODUCCIONES;
DROP TABLE TABLA_SINTAX;

-- Paquetes PL/SQL
DROP PACKAGE FSQL_PKG;
DROP PACKAGE FSQL_AUX;
DROP PACKAGE FSQL_SEMANTIC;
DROP PACKAGE FSQL_FUNCTIONS;
DROP PACKAGE FSQL_FUNCTIONS2;

-- Sinnimos
drop public synonym FSQL_ERRORS;
drop public synonym FSQL_QUERY;
drop public synonym FSQL_STATS;
drop public synonym FSQL_INFO;
drop public synonym FSQL_OPTIONS;
drop public synonym RESERVADAS;
drop public synonym FSQL_PKG;
drop public synonym FSQL_FUNCTIONS;
drop public synonym FSQL_FUNCTIONS2;

COMMIT;

-- Mensaje de FIN:
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> FIN de la DESINSTALACIN: Si existieron errores, revise su texto.');
exec dbms_output.put_line('>>>>');

-- Reestablecer los valores por defecto:
set serveroutput off
set feedback on
